<?php
require_once 'functions.php';

$update = json_decode(file_get_contents("php://input"), true);

if (isset($update["callback_query"])) {
    $callback_id = $update["callback_query"]["id"];
    $chat_id = $update["callback_query"]["message"]["chat"]["id"];
    $data = $update["callback_query"]["data"];
    $uidList = json_decode(file_get_contents("data.json"), true);

    if (strpos($data, "remove_") === 0) {
        $uidToRemove = str_replace("remove_", "", $data);
        $newList = array_filter($uidList, function ($u) use ($uidToRemove, $chat_id) {
            return !($u['uid'] == $uidToRemove && $u['chat_id'] == $chat_id);
        });
        file_put_contents("data.json", json_encode(array_values($newList), JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        answerCallback($callback_id, "✅ Đã dừng theo dõi UID $uidToRemove.");
    } elseif (strpos($data, "keep_") === 0) {
        $uidKeep = str_replace("keep_", "", $data);
        answerCallback($callback_id, "⏱ Vẫn tiếp tục theo dõi UID $uidKeep.");
    }
    exit;
}

// Nếu là tin nhắn thường
if (isset($update["message"])) {
    $message = $update["message"];
    $text = trim($message["text"]);
    $chat_id = $message["chat"]["id"];
    $data = file_exists('data.json') ? json_decode(file_get_contents('data.json'), true) : [];

  // /a – thêm nhiều UID
if (strpos($text, "/a") === 0) {
    $lines = explode("\n", $text);
    array_shift($lines); // Bỏ dòng đầu tiên "/a"
    $added = 0;

    foreach ($lines as $line) {
        if (preg_match('/(\d+)\s*-\s*(.*?)\s*-\s*(.*)/', $line, $matches)) {
            $uid = trim($matches[1]);
            $name = trim($matches[2]);
            $note = trim($matches[3]);

            $exists = false;
            foreach ($data as $item) {
                if ($item['uid'] === $uid && $item['chat_id'] == $chat_id) {
                    $exists = true;
                    break;
                }
            }
            if ($exists) continue;

            $status = checkUIDStatus($uid); // ✅ check ngay
            $timeNow = date('H:i:s - d/m/Y');

            $data[] = [
                'uid' => $uid,
                'name' => $name,
                'note' => $note,
                'status' => $status,
                'chat_id' => $chat_id,
                'last_check' => $timeNow,
                'added_at' => $timeNow
            ];

            // ✅ Gửi kết quả check ngay
            $photoUrl = "https://graph.facebook.com/{$uid}/picture?type=large";
            $profileLink = "<a href=\"https://facebook.com/{$uid}\">{$uid}</a>";

            if ($status === 'live') {
                $caption  = "✅ UID $profileLink → <b>Mở khóa thành công</b>\n\n";
                $caption .= "👤 Tên khách: $name\n";
                $caption .= "📝 Ghi chú: $note\n";
                $caption .= "📌 Bắt đầu kiểm tra: $timeNow\n";
                $caption .= "⏰ Mở khóa lúc: $timeNow";
            } elseif ($status === 'dead') {
                $caption  = "☠️ UID $profileLink → <b>Die</b>\n\n";
                $caption .= "👤 Tên khách: $name\n";
                $caption .= "📝 Ghi chú: $note\n";
                $caption .= "📌 Bắt đầu kiểm tra: $timeNow\n";
                $caption .= "⏰ Phát hiện die: $timeNow";
            } else {
                $caption  = "⚪ UID $profileLink → <b>Không xác định</b>\n\n";
                $caption .= "👤 Tên khách: $name\n";
                $caption .= "📝 Ghi chú: $note\n";
                $caption .= "📌 Bắt đầu kiểm tra: $timeNow";
            }

            $keyboard = [
                "inline_keyboard" => [
                    [
                        ["text" => "✅ Tiếp tục theo dõi", "callback_data" => "keep_{$uid}"],
                        ["text" => "❌ Dừng theo dõi", "callback_data" => "remove_{$uid}"]
                    ]
                ]
            ];

            sendPhotoWithKeyboard($chat_id, $photoUrl, $caption, $keyboard);
            $added++;

            usleep(300000); // tránh spam
        }
    }

    file_put_contents('data.json', json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    
    if ($added > 0) {
        sendMessage($chat_id, "✅ Đã thêm & kiểm tra <b>$added</b> UID.");
    } else {
        sendMessage($chat_id, "⚠️ Không có UID nào hợp lệ hoặc đã tồn tại.");
    }
}
    // /l – danh sách UID
    elseif (strpos($text, "/l") === 0) {
        $msg = "📄 <b>Danh sách UID theo dõi:</b>\n";
        $count = 0;
        $index = 1;

        foreach ($data as $item) {
            if ($item['chat_id'] == $chat_id) {
                $statusIcon = $item['status'] === 'live' ? "🟢" : ($item['status'] === 'dead' ? "🔴" : "⚪");
                $uid = $item['uid'];
                $name = htmlspecialchars($item['name'] ?: "Không tên");
                $note = !empty($item['note']) ? " - " . htmlspecialchars($item['note']) : "";

                $msg .= "$index. 👤 <b>{$name}</b> {$statusIcon}{$note}\n";
                $msg .= "🔢 UID: <a href='https://facebook.com/{$uid}'>{$uid}</a>\n";
                $index++;
                $count++;
            }
        }

        $msg .= "=> <b>Tổng cộng:</b> <code>$count</code> UID đang theo dõi.";
        sendMessage($chat_id, $msg);
    }
// /id – Xuất danh sách UID
elseif (strpos($text, "/id") === 0) {
    $uids = [];
    foreach ($data as $item) {
        if ($item['chat_id'] == $chat_id) {
            $uids[] = $item['uid'];
        }
    }

    if (empty($uids)) {
        sendMessage($chat_id, "⚠️ Không có UID nào trong danh sách.");
    } else {
        $msg = "📤 <b>Danh sách UID:</b>\n" . implode("\n", $uids);
        sendMessage($chat_id, $msg);
    }
}

// /dl – Xuất dữ liệu đầy đủ (UID - Tên - Ghi chú)
elseif (strpos($text, "/dl") === 0) {
    $lines = [];
    foreach ($data as $item) {
        if ($item['chat_id'] == $chat_id) {
            $uid = $item['uid'];
            $name = $item['name'] ?: "Không tên";
            $note = $item['note'] ?: "Không ghi chú";
            $lines[] = "$uid - $name - $note";
        }
    }

    if (empty($lines)) {
        sendMessage($chat_id, "⚠️ Không có dữ liệu để xuất.");
    } else {
        $msg = "📤 <b>Dữ liệu đầy đủ:</b>\n" . implode("\n", $lines);
        sendMessage($chat_id, $msg);
    }
}

    // /d UID – xóa UID
    elseif (strpos($text, "/d") === 0) {
        $uid = trim(str_replace("/d", "", $text));
        $found = false;
        foreach ($data as $i => $item) {
            if ($item['uid'] == $uid && $item['chat_id'] == $chat_id) {
                unset($data[$i]);
                $found = true;
            }
        }
        if ($found) {
            file_put_contents('data.json', json_encode(array_values($data), JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
            sendMessage($chat_id, "🗑️ Đã xóa UID <b>$uid</b> khỏi danh sách.");
        } else {
            sendMessage($chat_id, "⚠️ Không tìm thấy UID <b>$uid</b>.");
        }
    }

    // /k UID – kiểm tra trạng thái
    elseif (strpos($text, "/k") === 0) {
        $uid = trim(str_replace("/k", "", $text));
        if (!is_numeric($uid)) {
            sendMessage($chat_id, "❌ Vui lòng nhập UID hợp lệ.");
            exit;
        }

        $status = checkUIDStatus($uid);
        $statusText = $status === 'live' ? "🟢 UID <b>$uid</b> đang <b>Sống</b>" : ($status === 'dead' ? "🔴 UID <b>$uid</b> đã <b>Die</b>" : "⚪ UID <b>$uid</b> không xác định");

        sendMessage($chat_id, $statusText);
    }

    // /c – UID die
    elseif (strpos($text, "/c") === 0) {
        $deadList = array_filter($data, function ($item) use ($chat_id) {
            return $item['status'] === 'dead' && $item['chat_id'] == $chat_id;
        });

        if (empty($deadList)) {
            sendMessage($chat_id, "✅ Không có UID nào die.");
        } else {
            $msg = "☠️ <b>Danh sách UID die:</b>\n";
            $index = 1;
            foreach ($deadList as $item) {
                $note = !empty($item['note']) ? " - {$item['note']}" : "";
                $msg .= "$index. 👤 <b>{$item['name']}</b> 🔴{$note}\n";
                $msg .= "ID: <code>{$item['uid']}</code>\n";
                $index++;
            }
            $msg .= "=> Tổng cộng: <b>" . count($deadList) . "</b> UID die.";
            sendMessage($chat_id, $msg);
        }
    }

    // /s – UID sống
    elseif (strpos($text, "/s") === 0) {
        $liveList = array_filter($data, function ($item) use ($chat_id) {
            return $item['status'] === 'live' && $item['chat_id'] == $chat_id;
        });

        if (empty($liveList)) {
            sendMessage($chat_id, "⚠️ Không có UID nào sống.");
        } else {
            $msg = "🟢 <b>Danh sách UID sống:</b>\n";
            $index = 1;
            foreach ($liveList as $item) {
                $note = !empty($item['note']) ? " - {$item['note']}" : "";
                $msg .= "$index. 👤 <b>{$item['name']}</b> 🟢{$note}\n";
                $msg .= "ID: <code>{$item['uid']}</code>\n";
                $index++;
            }
            $msg .= "=> Tổng cộng: <b>" . count($liveList) . "</b> UID sống.";
            sendMessage($chat_id, $msg);
        }
    }

    // /start – hướng dẫn
    elseif (strpos($text, "/start") === 0) {
        sendMessage($chat_id, "👋 Xin chào! Các lệnh hỗ trợ:\n\n" .
            "/a – Thêm nhiều UID (mỗi dòng: UID - Tên - Ghi chú)\n" .
            "/d UID – Xóa UID khỏi danh sách\n" .
            "/l – Xem danh sách UID đang theo dõi\n" .
            "/k UID – Kiểm tra trạng thái UID (live/die)\n" .
            "/c – Danh sách UID die\n" .
            "/s – Danh sách UID sống\n" .
            "/help – Hướng dẫn sử dụng bot");
    }
}
